/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.drop;

import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiTextArea;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.DropNbtSet;

public class SubGuiDropValueNbt
extends SubGuiInterface
implements ITextfieldListener,
ITextChangeListener {
    public DropNbtSet tag;
    private final String[] tagIds;
    private final String[] tagListIds;
    private GuiTextArea textarea;

    public SubGuiDropValueNbt(DropNbtSet tg) {
        this.setBackground("companion_empty.png");
        this.xSize = 172;
        this.ySize = 167;
        this.closeOnEsc = true;
        this.tag = tg;
        String[] ids = new String[11];
        for (int i = 0; i < 10; ++i) {
            ids[i] = "tag.type." + i;
        }
        ids[10] = "tag.type.11";
        this.tagIds = ids;
        String[] lids = new String[]{"tag.type.3", "tag.type.5", "tag.type.6", "tag.type.8", "tag.type.11"};
        this.tagListIds = lids;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 90: {
                this.tag.setType(Integer.parseInt(button.getVariants()[button.getValue()].replace("tag.type.", "")));
                this.func_73866_w_();
                break;
            }
            case 91: {
                this.close();
                break;
            }
            case 92: {
                this.tag.setTypeList(Integer.parseInt(button.getVariants()[button.getValue()].replace("tag.type.", "")));
                this.func_73866_w_();
            }
        }
    }

    private boolean check() {
        if (this.getTextField(93) == null || this.textarea == null) {
            return false;
        }
        if (this.getTextField(93).getFullText().isEmpty() || this.textarea.getFullText().isEmpty()) {
            return false;
        }
        String vs = this.textarea.getFullText();
        if (vs.contains("|")) {
            for (String str : vs.split("\\|")) {
                String ch = this.tag.checkValue(str, this.tag.getType());
                if (ch != null) continue;
                return false;
            }
        } else {
            String ch = this.tag.checkValue(vs, this.tag.getType());
            if (ch != null) {
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int anyIDs = 100;
        int t = this.tag.getType();
        int tl = this.tag.getTypeList();
        String name = this.tag.getPath();
        if (name.contains(".")) {
            while (name.contains(".")) {
                name = name.substring(name.indexOf(".") + 1);
            }
        }
        String type = new TextComponentTranslation("tag.type." + t, new Object[0]).func_150254_d();
        GuiNpcLabel label = new GuiNpcLabel(anyIDs++, new TextComponentTranslation("drop.tag.type", new Object[]{name, type}).func_150254_d(), this.guiLeft + 4, this.guiTop + 5);
        label.setHoverText("drop.hover.tag.name", new Object[0]);
        this.addLabel(label);
        GuiNpcTextField textField = new GuiNpcTextField(93, this, this.guiLeft + 4, this.guiTop + 18, 163, 20, this.tag.getPath());
        textField.setHoverText("drop.hover.tag.path", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(anyIDs++, "type.value", this.guiLeft + 4, this.guiTop + 40));
        String[] textArr = this.tag.getValues();
        StringBuilder text = new StringBuilder();
        if (textArr.length > 0) {
            text = new StringBuilder(textArr[0]);
        }
        if (textArr.length > 1) {
            for (int i = 1; i < textArr.length; ++i) {
                text.append("|").append(textArr[i]);
            }
        }
        this.textarea = new GuiTextArea(94, this.guiLeft + 4, this.guiTop + 53, 163, 65, text.toString());
        this.textarea.setListener(this);
        this.textarea.active = true;
        if (t == 7 || t == 11) {
            this.textarea.setHoverText("drop.hover.tag.value.array", name);
        } else if (t == 9) {
            this.textarea.setHoverText("drop.hover.tag.value.list", name);
        } else {
            this.textarea.setHoverText("drop.hover.tag.value.normal", name);
        }
        this.add(this.textarea);
        this.addLabel(new GuiNpcLabel(anyIDs, "drop.chance", this.guiLeft + 56, this.guiTop + 125));
        textField = new GuiNpcTextField(95, this, this.guiLeft + 4, this.guiTop + 120, 50, 20, String.valueOf(this.tag.getChance()));
        textField.setMinMaxDoubleDefault(1.0E-4, 100.0, this.tag.getChance());
        textField.setHoverText("drop.hover.tag.chance", new Object[0]);
        this.addTextField(textField);
        int posId = 0;
        for (int i = 0; i < this.tagIds.length; ++i) {
            if (!this.tagIds[i].equals("tag.type." + this.tag.getType())) continue;
            posId = i;
        }
        name = "\u00a72" + name;
        GuiNpcButton button = new GuiButtonBiDirectional(90, this.guiLeft + 87, this.guiTop + 120, 80, 20, this.tagIds, posId);
        button.setHoverText("drop.hover.tag.type", name, this.getValuesData(t));
        this.addButton(button);
        int posListId = 0;
        for (int i = 0; i < this.tagListIds.length; ++i) {
            if (!this.tagListIds[i].equals("tag.type." + this.tag.getTypeList())) continue;
            posListId = i;
        }
        button = new GuiButtonBiDirectional(92, this.guiLeft + 87, this.guiTop + 142, 80, 20, this.tagListIds, posListId);
        button.setHoverText("drop.hover.tag.listtype", name, this.getValuesData(tl));
        button.setIsVisible(t == 9);
        this.addButton(button);
        button = new GuiNpcButton(91, this.guiLeft + 4, this.guiTop + 142, 80, 20, "gui.done", this.check());
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    private String getValuesData(int t) {
        String gn = "\u00a72";
        String r = "\u00a7c";
        String gr = "\u00a77";
        if (t == 1) {
            return gn + -128 + gr + "<->" + r + 127;
        }
        if (t == 2) {
            return gn + Short.MIN_VALUE + gr + "<->" + r + Short.MAX_VALUE;
        }
        if (t == 3) {
            return gn + Integer.MIN_VALUE + gr + "<->" + r + Integer.MAX_VALUE;
        }
        if (t == 4) {
            return gn + Long.MIN_VALUE + gr + "<->" + r + Long.MAX_VALUE;
        }
        if (t == 5) {
            return new TextComponentTranslation("type.double", new Object[]{"77"}).func_150254_d();
        }
        if (t == 6) {
            return new TextComponentTranslation("type.double", new Object[]{"308"}).func_150254_d();
        }
        if (t == 7) {
            return "array [v0, v1, ... vn] v_ = " + gn + -128 + gr + "<->" + r + 127;
        }
        if (t == 8) {
            return new TextComponentTranslation("type.string", new Object[0]).func_150254_d();
        }
        if (t == 9) {
            return new TextComponentTranslation("type.list", new Object[0]).func_150254_d();
        }
        if (t == 11) {
            return "array [v0, v1, ... vn] v_ = " + gn + Integer.MIN_VALUE + gr + "<->" + r + Integer.MAX_VALUE;
        }
        return gn + "true" + gr + ", " + gn + "false";
    }

    @Override
    public void textUpdate(String text) {
        this.tag.setValues(text);
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        if (textfield.getID() == 93) {
            this.tag.setPath(textfield.getFullText());
        } else if (textfield.getID() == 95) {
            this.tag.setChance(textfield.getDouble());
        }
        this.func_73866_w_();
    }
}

